<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('income.list_title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="<?php echo e(route('income.index')); ?>">
										<?php echo e(csrf_field()); ?>

										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control"
												placeholder="<?php echo e(__('income.ph_search')); ?>" required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th><?php echo e(__('income.th_name')); ?></th>
													<th class="nowrap"><?php echo e(__('income.th_amount')); ?></th>
													<th class="nowrap"><?php echo e(__('income.th_date')); ?></th>
													<th class="nowrap"><?php echo e(__('income.th_description')); ?></th>
													<th class="fixed-width-td"><?php echo e(__('income.th_action')); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php $__currentLoopData = $incomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $income): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td class="align-middle"><?php echo e($income->name); ?></td>
													<td class="align-middle nowrap"><?php echo e(format_amount($income->transaction->amount)); ?></td>
													<td class="align-middle nowrap"><?php echo e(format_date($income->transaction->date)); ?></td>
													<td class="align-middle nowrap"><?php echo e($income->transaction->note); ?>

													</td>
													<td>
														<div class="d-flex">
															<a href="<?php echo e(route('income.edit', $income->id)); ?>"
																type="button" class="btn btn-warning mr-2"><i
																	class="fa fa-edit"></i></a>
															<form class="d-inline js-confirm-delete" method="POST"
																action="<?php echo e(route('income.destroy', $income->id)); ?>">
																<?php echo e(csrf_field()); ?>

																<?php echo method_field('DELETE'); ?>
																<button class="btn btn-primary"><i
																		class="fa fa-trash"></i></button>
															</form>
														</div>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php if(count($incomes) == 0): ?>
												<tr>
													<td colspan="11">
														<p class="text-center mb-0"><?php echo e(__('income.no_record_found')); ?>

														</p>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										<?php if($paginate): ?>
										<?php echo e($incomes->links()); ?>

										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/income/list.blade.php ENDPATH**/ ?>